//---------------------------------------------------------------------------
#include "Brainiac.h"

#include <stdio.h>

#define EXPO _export  //if not using Borland tools, redefine it

#define MAX_NAME_LEN 25
#define MAX_ITEM_NAME_LEN 50
#define AVG_PRICE 100
#define AVG_SCORE 9
#define MAX_ACT_NAME_LEN 21

//---------------------------------------------------------------------------
typedef enum { itMisc = 0, itWeapon = 1, itArmor = 2, itReagent = 3,
	itGarment = 4} ItemType;

typedef ItemScores* ItemPtr;
//---------------------------------------------------------------------------
class EXPO InventoryItem {
public:
	InventoryItem();
    ~InventoryItem();
	ID ItemID;
	ItemScores BEStuff;
    void SetBEScores(percentage argWick, percentage argAna, percentage
    	argMean, percentage argFor, percentage argWeal, percentage argBeauty,
        percentage argPers);
    unsigned short Price;
    ItemType _Type;
    char Descr[ MAX_ITEM_NAME_LEN ];
    InventoryItem *next;//this is just a demo... A simple linked list will do
};

//---------------------------------------------------------------------------
class EXPO Character
{
public:
	Character();
    Character(Core);
    void Init(Core);
	~Character();
    void SetBEScores(Core);
    void ClearInventory();
    void EnumInventory();
    unsigned short ItemsQty();
    InventoryItem *GetItem(ID, InventoryItem ** = NULL);
    InventoryItem *GetItem(ItemScores *,InventoryItem ** = NULL);
    void AddItem(InventoryItem*);
    unsigned short InvListToArray(ItemPtrArr *);
    unsigned short FillSaveBuffer(BYTE *);
    void RestoreFromBufferStep1(BYTE *,unsigned short nLen);
    void RestoreFromBufferStep2(BYTE *,unsigned short ,
        Agent **, unsigned short ,
        ItemPtrArr* , unsigned short *);
    //attributes
	Agent BEStuff;
    ID CharID;
    char szName[MAX_NAME_LEN];
    static ID cAutoNumber;
    double Cash;
    BOOL IsActive;
    BOOL IsPlayerCharacter;
    InventoryItem *InventoryHead;
};

struct _CharacterNode{
	Character ch;
    //this is just a demo... A simple linked list will do
	struct _CharacterNode *next;
};
typedef struct _CharacterNode* CharacterNode;

//---------------------------------------------------------------------------
struct _GroupNode{
    Group g;
    char szName[20];
    struct _GroupNode *next;
};
typedef struct _GroupNode* GroupNode;
//---------------------------------------------------------------------------
Character *GetCharacter(ID argCharID);
Character *GetCharacter(int nIndex);
Character *AddCharacter(Character&);
Character *SetCharacter(Character &argChar);
BOOL DelCharacter(ID argCharID);

InventoryItem *GetItem(InventoryItem *,ID ,InventoryItem ** = NULL);
InventoryItem *GetItemN(InventoryItem *,unsigned short ,
    InventoryItem ** = NULL);

//void AddCharacter(percentage,percentage,percentage,percentage,Core);
void FreeCharList();
void NextEvent();
Character *GetActionTarget(Action *);
unsigned short MakePopulationArray(Agent ***);
percentage Price2WealthPts(double );
double WealthPts2Cash(percentage );

char *RandomName();
BOOL ChoiceYN(char*,char*);
//---------------------------------------------------------------------------
typedef struct {
    Character *Initiator;
    GroupNode Squad;
    Action *ToBeExecuted;
} InteractionParam;

//---------------------------------------------------------------------------
void HandleExecution(Character *);
int EXPO Attack(InteractionParam *);
int GroupAttack(InteractionParam *);
int EXPO NonLethalAttack(InteractionParam *);
int EXPO GroupNonLethalAttack(InteractionParam *);
int EXPO Statement(InteractionParam *);
int EXPO Request(InteractionParam *);
int EXPO Deal(InteractionParam *);
int EXPO Tease(InteractionParam *);
int EXPO TakeItem(InteractionParam *);
int EXPO Steal(InteractionParam *);
int EXPO GiveItem(InteractionParam *);
int EXPO Threat(InteractionParam *);
int EXPO GatherGang(InteractionParam *);
int EXPO Leave(InteractionParam *);
void GetWording(Action *,char *,unsigned char);
int DefaultFn(InteractionParam *);
void DiscardCorpses();
BOOL CheckInteractionParam(InteractionParam *);
int AccomplishPromise(Action *, Character *, percentage = 1);
void SaveAllCharacters(char *);
void RestoreAllCharacters(char *);
void DiscardInactiveGroups();

int CheckMember(InteractionParam *);
InventoryItem *SetMoneyInInv(InventoryItem **, double ,BOOL = FALSE);
//---------------------------------------------------------------------------

